/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.peripheral.modem.wired;

import com.google.common.collect.ImmutableMap;
import dan200.computercraft.shared.peripheral.modem.ModemShapes;
import dan200.computercraft.shared.peripheral.modem.wired.BlockCable;
import dan200.computercraft.shared.peripheral.modem.wired.CableModemVariant;
import dan200.computercraft.shared.util.DirectionUtil;
import java.util.EnumMap;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public final class CableShapes {
    private static final double MIN = 0.375;
    private static final double MAX = 0.625;
    private static final VoxelShape SHAPE_CABLE_CORE = Shapes.m_83048_((double)0.375, (double)0.375, (double)0.375, (double)0.625, (double)0.625, (double)0.625);
    private static final EnumMap<Direction, VoxelShape> SHAPE_CABLE_ARM = new EnumMap(new ImmutableMap.Builder().put((Object)Direction.DOWN, (Object)Shapes.m_83048_((double)0.375, (double)0.0, (double)0.375, (double)0.625, (double)0.375, (double)0.625)).put((Object)Direction.UP, (Object)Shapes.m_83048_((double)0.375, (double)0.625, (double)0.375, (double)0.625, (double)1.0, (double)0.625)).put((Object)Direction.NORTH, (Object)Shapes.m_83048_((double)0.375, (double)0.375, (double)0.0, (double)0.625, (double)0.625, (double)0.375)).put((Object)Direction.SOUTH, (Object)Shapes.m_83048_((double)0.375, (double)0.375, (double)0.625, (double)0.625, (double)0.625, (double)1.0)).put((Object)Direction.WEST, (Object)Shapes.m_83048_((double)0.0, (double)0.375, (double)0.375, (double)0.375, (double)0.625, (double)0.625)).put((Object)Direction.EAST, (Object)Shapes.m_83048_((double)0.625, (double)0.375, (double)0.375, (double)1.0, (double)0.625, (double)0.625)).build());
    private static final VoxelShape[] SHAPES = new VoxelShape[448];
    private static final VoxelShape[] CABLE_SHAPES = new VoxelShape[64];

    private CableShapes() {
    }

    private static int getCableIndex(BlockState state) {
        int index = 0;
        for (Direction facing : DirectionUtil.FACINGS) {
            if (!((Boolean)state.m_61143_((Property)BlockCable.CONNECTIONS.get(facing))).booleanValue()) continue;
            index |= 1 << facing.ordinal();
        }
        return index;
    }

    private static VoxelShape getCableShape(int index) {
        VoxelShape shape = CABLE_SHAPES[index];
        if (shape != null) {
            return shape;
        }
        shape = SHAPE_CABLE_CORE;
        for (Direction facing : DirectionUtil.FACINGS) {
            if ((index & 1 << facing.ordinal()) == 0) continue;
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)SHAPE_CABLE_ARM.get(facing));
        }
        CableShapes.CABLE_SHAPES[index] = shape;
        return CableShapes.CABLE_SHAPES[index];
    }

    public static VoxelShape getCableShape(BlockState state) {
        if (!((Boolean)state.m_61143_((Property)BlockCable.CABLE)).booleanValue()) {
            return Shapes.m_83040_();
        }
        return CableShapes.getCableShape(CableShapes.getCableIndex(state));
    }

    public static VoxelShape getModemShape(BlockState state) {
        Direction facing = ((CableModemVariant)((Object)state.m_61143_(BlockCable.MODEM))).getFacing();
        return facing == null ? Shapes.m_83040_() : ModemShapes.getBounds(facing);
    }

    public static VoxelShape getShape(BlockState state) {
        Direction facing = ((CableModemVariant)((Object)state.m_61143_(BlockCable.MODEM))).getFacing();
        if (!((Boolean)state.m_61143_((Property)BlockCable.CABLE)).booleanValue()) {
            return CableShapes.getModemShape(state);
        }
        int cableIndex = CableShapes.getCableIndex(state);
        int index = cableIndex + ((facing == null ? 0 : facing.ordinal() + 1) << 6);
        VoxelShape shape = SHAPES[index];
        if (shape != null) {
            return shape;
        }
        shape = CableShapes.getCableShape(cableIndex);
        if (facing != null) {
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)ModemShapes.getBounds(facing));
        }
        CableShapes.SHAPES[index] = shape;
        return CableShapes.SHAPES[index];
    }
}

